/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client.firstpersonrender;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import java.util.Optional;
import net.bettercombat.client.BetterCombatClient;
import net.bettercombat.client.PlayerAttackAnimatable;
import net.bettercombat.client.animation.FirstPersonRenderHelper;
import net.bettercombat.client.animation.IExtendedAnimation;
import net.bettercombat.compatibility.CompatibilityFlags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public class HeldItemRendererMixin {
    @Inject(method={"renderItem(FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider$Immediate;Lnet/minecraft/client/network/ClientPlayerEntity;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontRenderItem(float tickDelta, PoseStack matrices, MultiBufferSource.BufferSource vertexConsumers, LocalPlayer player, int light, CallbackInfo ci) {
        if (!CompatibilityFlags.firstPersonRender()) {
            return;
        }
        Optional<IAnimation> currentAnimation = ((PlayerAttackAnimatable)player).getCurrentAnimation();
        if (currentAnimation.isPresent()) {
            boolean isActive = currentAnimation.get().isActive();
            IAnimation iAnimation = currentAnimation.get();
            if (iAnimation instanceof IExtendedAnimation) {
                IExtendedAnimation extendedAnimation = (IExtendedAnimation)iAnimation;
                isActive = extendedAnimation.isActiveInFirstPerson();
            }
            if (isActive) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"renderItem(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformation$Mode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderItem_HEAD(LivingEntity entity, ItemStack stack, ItemTransforms.TransformType renderMode, boolean leftHanded, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (entity != player) {
            return;
        }
        if (FirstPersonRenderHelper.isRenderingFirstPersonPlayerModel && !BetterCombatClient.config.isShowingOtherHandFirstPerson) {
            boolean isMainHandStack;
            boolean bl = isMainHandStack = player.m_21205_() == stack;
            if (FirstPersonRenderHelper.isAttackingWithOffHand) {
                if (isMainHandStack) {
                    ci.cancel();
                }
            } else if (!isMainHandStack) {
                ci.cancel();
            }
        }
    }
}

