/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.verdure.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class BranchBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    private final Block log;
    private final Block fallenLeaves;
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LEAVES = BooleanProperty.m_61465_((String)"leaves");

    public BranchBlock(Block log, Block fallenLeaves, BlockBehaviour.Properties properties) {
        super(properties);
        this.log = log;
        this.fallenLeaves = fallenLeaves;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEAVES, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return ((Direction)pState.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    private boolean canAttachTo(BlockGetter pBlockReader, BlockPos pPos) {
        return pBlockReader.m_8055_(pPos).m_60713_(this.log);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.m_61143_((Property)f_54117_);
        return this.canAttachTo((BlockGetter)pLevel, pPos.m_142300_(direction.m_122424_()));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing.m_122424_() == pState.m_61143_((Property)f_54117_) && !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state;
        if (!pContext.m_7058_() && (state = pContext.m_43725_().m_8055_(pContext.m_8083_().m_142300_(pContext.m_43719_().m_122424_()))).m_60713_((Block)this) && state.m_61143_((Property)f_54117_) == pContext.m_43719_()) {
            return null;
        }
        BlockState defaultBlockState = this.m_49966_();
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        FluidState fluidState = pContext.m_43725_().m_6425_(pContext.m_8083_());
        for (Direction direction : pContext.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(defaultBlockState = (BlockState)defaultBlockState.m_61124_((Property)f_54117_, (Comparable)direction.m_122424_())).m_60710_((LevelReader)level, pos)) continue;
            return (BlockState)defaultBlockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, WATERLOGGED, LEAVES});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_6724_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)LEAVES) == false;
    }

    public void m_7455_(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        if (pRandom.nextInt(5) == 0) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)LEAVES, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (toolAction.equals(ToolActions.SHEARS_HARVEST) && ((Boolean)state.m_61143_((Property)LEAVES)).booleanValue() && context.m_43722_().canPerformAction(ToolActions.SHEARS_HARVEST)) {
            return (BlockState)state.m_61124_((Property)LEAVES, (Comparable)Boolean.valueOf(false));
        }
        return super.getToolModifiedState(state, context, toolAction, simulate);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        boolean canShear = false;
        if (((Boolean)pState.m_61143_((Property)LEAVES)).booleanValue()) {
            if (stack.canPerformAction(ToolActions.SHEARS_HARVEST)) {
                pLevel.m_6263_(pPlayer, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12344_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                BranchBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this.fallenLeaves));
                stack.m_41622_(1, (LivingEntity)pPlayer, player -> player.m_21190_(pHand));
                canShear = true;
                pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157781_, pPos);
            }
            if (!pLevel.m_5776_() && canShear) {
                pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
        }
        if (canShear) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LEAVES, (Comparable)Boolean.valueOf(false)));
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 100;
    }
}

