/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.verdure.event;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import samebutdifferent.verdure.Verdure;
import samebutdifferent.verdure.block.WallRootsBlock;
import samebutdifferent.verdure.registry.VerdureBlocks;
import samebutdifferent.verdure.registry.VerdureConfig;
import samebutdifferent.verdure.registry.VerdurePlacedFeatures;
import samebutdifferent.verdure.util.CodecUtils;

@Mod.EventBusSubscriber(modid="verdure")
public class CommonEventHandler {
    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        ResourceLocation location = event.getName();
        if (location != null) {
            switch (event.getCategory()) {
                case FOREST: {
                    if (location.equals((Object)Biomes.f_48149_.m_135782_())) {
                        CommonEventHandler.replaceTrees(event, location, (Holder<PlacedFeature>)VegetationPlacements.f_195436_, VerdurePlacedFeatures.TREES_BIRCH);
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.BIRCH_DAISIES, (Boolean)VerdureConfig.GENERATE_DAISY_TREE.get());
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_WILDFLOWERS, (Boolean)VerdureConfig.GENERATE_DAISIES_PATCH.get());
                    }
                    if (location.equals((Object)Biomes.f_186762_.m_135782_())) {
                        CommonEventHandler.replaceTrees(event, location, (Holder<PlacedFeature>)VegetationPlacements.f_195435_, VerdurePlacedFeatures.BIRCH_TALL);
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.BIRCH_DAISIES, (Boolean)VerdureConfig.GENERATE_DAISY_TREE.get());
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_WILDFLOWERS, (Boolean)VerdureConfig.GENERATE_DAISIES_PATCH.get());
                    }
                    if (location.equals((Object)Biomes.f_48205_.m_135782_())) {
                        CommonEventHandler.replaceTrees(event, location, (Holder<PlacedFeature>)VegetationPlacements.f_195440_, VerdurePlacedFeatures.TREES_BIRCH_AND_OAK);
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.OAK_DAISIES, (Boolean)VerdureConfig.GENERATE_DAISY_TREE.get());
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.BIRCH_DAISIES, (Boolean)VerdureConfig.GENERATE_DAISY_TREE.get());
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.OAK_HOLLOW, (Boolean)VerdureConfig.GENERATE_OAK_HOLLOW.get());
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FANCY_OAK_HOLLOW, (Boolean)VerdureConfig.GENERATE_OAK_HOLLOW.get());
                    }
                    if (location.equals((Object)Biomes.f_48179_.m_135782_())) {
                        CommonEventHandler.replaceTrees(event, location, (Holder<PlacedFeature>)VegetationPlacements.f_195425_, VerdurePlacedFeatures.TREES_FLOWER_FOREST);
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_WILDFLOWERS, (Boolean)VerdureConfig.GENERATE_DAISIES_PATCH.get());
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.OAK_HOLLOW, (Boolean)VerdureConfig.GENERATE_OAK_HOLLOW.get());
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FANCY_OAK_HOLLOW, (Boolean)VerdureConfig.GENERATE_OAK_HOLLOW.get());
                    }
                    if (((Boolean)VerdureConfig.GENERATE_DARK_OAK_HUMUS.get()).booleanValue()) {
                        CommonEventHandler.replaceTrees(event, Biomes.f_48151_.m_135782_(), (Holder<PlacedFeature>)VegetationPlacements.f_195422_, VerdurePlacedFeatures.DARK_FOREST_VEGETATION);
                    }
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.LOCAL_MODIFICATIONS, VerdurePlacedFeatures.BOULDER_STONE, (Boolean)VerdureConfig.GENERATE_BOULDER.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH, (Boolean)VerdureConfig.GENERATE_SMOOTH_DIRT_PATCH.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG, (Boolean)VerdureConfig.GENERATE_FALLEN_LOG.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.MUSHROOM_SHELF, (Boolean)VerdureConfig.GENERATE_MUSHROOM_SHELF_SURFACE.get());
                    CommonEventHandler.addGrassyAreaFeatures(builder);
                    break;
                }
                case PLAINS: {
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH, (Boolean)VerdureConfig.GENERATE_SMOOTH_DIRT_PATCH.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG, (Boolean)VerdureConfig.GENERATE_FALLEN_LOG.get());
                    CommonEventHandler.addGrassyAreaFeatures(builder);
                    break;
                }
                case RIVER: {
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.LOCAL_MODIFICATIONS, VerdurePlacedFeatures.BOULDER_SLATE, (Boolean)VerdureConfig.GENERATE_BOULDER.get());
                    break;
                }
                case JUNGLE: {
                    CommonEventHandler.replaceTrees(event, Biomes.f_186769_.m_135782_(), (Holder<PlacedFeature>)VegetationPlacements.f_195441_, VerdurePlacedFeatures.TREES_SPARSE_JUNGLE);
                    CommonEventHandler.replaceTrees(event, Biomes.f_48222_.m_135782_(), (Holder<PlacedFeature>)VegetationPlacements.f_195444_, VerdurePlacedFeatures.TREES_JUNGLE);
                    CommonEventHandler.replaceTrees(event, Biomes.f_48197_.m_135782_(), (Holder<PlacedFeature>)VegetationPlacements.f_195444_, VerdurePlacedFeatures.TREES_JUNGLE);
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.LOCAL_MODIFICATIONS, VerdurePlacedFeatures.BOULDER_SLATE, (Boolean)VerdureConfig.GENERATE_BOULDER.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH, (Boolean)VerdureConfig.GENERATE_SMOOTH_DIRT_PATCH.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.HUMUS_PATCH, (Boolean)VerdureConfig.GENERATE_HUMUS_PATCH.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG, (Boolean)VerdureConfig.GENERATE_FALLEN_LOG.get());
                    CommonEventHandler.addGrassyAreaFeatures(builder);
                    break;
                }
                case TAIGA: {
                    if (location.equals((Object)Biomes.f_48206_.m_135782_()) || location.equals((Object)Biomes.f_48152_.m_135782_())) {
                        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.LOCAL_MODIFICATIONS, VerdurePlacedFeatures.BOULDER_DIORITE, (Boolean)VerdureConfig.GENERATE_BOULDER.get());
                    }
                    CommonEventHandler.replaceTrees(event, Biomes.f_48206_.m_135782_(), (Holder<PlacedFeature>)VegetationPlacements.f_195428_, VerdurePlacedFeatures.TREES_TAIGA);
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH, (Boolean)VerdureConfig.GENERATE_SMOOTH_DIRT_PATCH.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG, (Boolean)VerdureConfig.GENERATE_FALLEN_LOG.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.MUSHROOM_SHELF, (Boolean)VerdureConfig.GENERATE_MUSHROOM_SHELF_SURFACE.get());
                    CommonEventHandler.addGrassyAreaFeatures(builder);
                    break;
                }
                case SAVANNA: {
                    CommonEventHandler.replaceTrees(event, Biomes.f_48157_.m_135782_(), (Holder<PlacedFeature>)VegetationPlacements.f_195434_, VerdurePlacedFeatures.TREES_SAVANNA);
                    CommonEventHandler.replaceTrees(event, Biomes.f_186768_.m_135782_(), (Holder<PlacedFeature>)VegetationPlacements.f_195433_, VerdurePlacedFeatures.TREES_WINDSWEPT_SAVANNA);
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.LOCAL_MODIFICATIONS, VerdurePlacedFeatures.BOULDER_GRANITE, (Boolean)VerdureConfig.GENERATE_BOULDER.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH, (Boolean)VerdureConfig.GENERATE_SMOOTH_DIRT_PATCH.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG_SAVANNA, (Boolean)VerdureConfig.GENERATE_FALLEN_LOG.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_CLOVER, (Boolean)VerdureConfig.GENERATE_CLOVER_PATCH.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PEBBLES, (Boolean)VerdureConfig.GENERATE_PEBBLES.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.ROCK, (Boolean)VerdureConfig.GENERATE_ROCK.get());
                    break;
                }
                case BEACH: {
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.LOCAL_MODIFICATIONS, VerdurePlacedFeatures.BOULDER_ANDESITE, (Boolean)VerdureConfig.GENERATE_BOULDER.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PEBBLES, (Boolean)VerdureConfig.GENERATE_PEBBLES.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.ROCK, (Boolean)VerdureConfig.GENERATE_ROCK.get());
                    break;
                }
                case SWAMP: {
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.UNDERGROUND_ORES, VerdurePlacedFeatures.SMOOTH_DIRT_PATCH_SWAMP, (Boolean)VerdureConfig.GENERATE_SMOOTH_DIRT_PATCH.get());
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.MUSHROOM_SHELF, (Boolean)VerdureConfig.GENERATE_MUSHROOM_SHELF_SURFACE.get());
                    CommonEventHandler.addGrassyAreaFeatures(builder);
                    break;
                }
                case NETHER: {
                    if (!location.equals((Object)Biomes.f_48201_.m_135782_()) && !location.equals((Object)Biomes.f_48200_.m_135782_())) break;
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.FALLEN_LOG_NETHER, (Boolean)VerdureConfig.GENERATE_FALLEN_LOG_NETHER.get());
                    break;
                }
                case UNDERGROUND: {
                    if (!location.equals((Object)Biomes.f_151785_.m_135782_())) break;
                    CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.HANGING_MOSS, (Boolean)VerdureConfig.GENERATE_HANGING_MOSS.get());
                }
            }
        }
        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.UNDERGROUND_MUSHROOM_SHELF, (Boolean)VerdureConfig.GENERATE_MUSHROOM_SHELF_UNDERGROUND.get());
    }

    private static void addFeature(BiomeGenerationSettingsBuilder builder, GenerationStep.Decoration decorationStage, RegistryObject<PlacedFeature> feature, boolean config) {
        if (config) {
            builder.m_204201_(decorationStage, (Holder)feature.getHolder().orElseThrow());
        }
    }

    private static void replaceTrees(BiomeLoadingEvent event, ResourceLocation biomeLocation, Holder<PlacedFeature> originalFeature, RegistryObject<PlacedFeature> replacementFeature) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        ResourceLocation location = event.getName();
        if (replacementFeature.getHolder().isPresent() && location != null && location.equals((Object)biomeLocation) && (((Boolean)VerdureConfig.GENERATE_TREE_BRANCHES.get()).booleanValue() || (Double)VerdureConfig.FALLEN_LEAVES_CHANCE.get() > 0.0)) {
            builder.getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).removeIf(placedFeatureSupplier -> CodecUtils.serializeAndCompareFeature((PlacedFeature)placedFeatureSupplier.m_203334_(), (PlacedFeature)originalFeature.m_203334_()));
            builder.getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).add((Holder)replacementFeature.getHolder().get());
            Verdure.LOGGER.debug("Replaced " + ((ResourceKey)originalFeature.m_203543_().get()).m_135782_() + " in " + location + " with " + replacementFeature.getId());
        }
    }

    private static void addGrassyAreaFeatures(BiomeGenerationSettingsBuilder builder) {
        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_CLOVER, (Boolean)VerdureConfig.GENERATE_CLOVER_PATCH.get());
        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PEBBLES, (Boolean)VerdureConfig.GENERATE_PEBBLES.get());
        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.ROCK, (Boolean)VerdureConfig.GENERATE_ROCK.get());
        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_DAISIES, (Boolean)VerdureConfig.GENERATE_DAISIES_PATCH.get());
        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_DAISIES_BLUE, (Boolean)VerdureConfig.GENERATE_DAISIES_PATCH.get());
        CommonEventHandler.addFeature(builder, GenerationStep.Decoration.VEGETAL_DECORATION, VerdurePlacedFeatures.PATCH_DAISIES_PINK, (Boolean)VerdureConfig.GENERATE_DAISIES_PATCH.get());
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        CodecUtils.clearCache();
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        Player player = event.getPlayer();
        Level level = player.f_19853_;
        ItemStack stack = event.getItemStack();
        if (WallRootsBlock.canAttachTo((BlockGetter)level, event.getPos(), event.getFace()) && event.getFace().m_122434_().m_122480_() == Direction.Plane.HORIZONTAL && level.m_46859_(pos = event.getHitVec().m_82425_().m_142300_(event.getFace()))) {
            if (stack.m_150930_(Items.f_41952_)) {
                CommonEventHandler.placeBlock(event, player, level, pos, stack, (Block)VerdureBlocks.BROWN_MUSHROOM_SHELF.get());
            } else if (stack.m_150930_(Items.f_41953_)) {
                CommonEventHandler.placeBlock(event, player, level, pos, stack, (Block)VerdureBlocks.RED_MUSHROOM_SHELF.get());
            } else if (stack.m_150930_(Items.f_151017_)) {
                CommonEventHandler.placeBlock(event, player, level, pos, stack, (Block)VerdureBlocks.WALL_ROOTS.get());
            }
        }
    }

    private static void placeBlock(PlayerInteractEvent.RightClickBlock event, Player player, Level level, BlockPos pos, ItemStack stack, Block block) {
        BlockState state = block.m_5573_(new BlockPlaceContext(player, event.getHand(), stack, event.getHitVec()));
        if (state != null && block.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46597_(pos, state);
            player.m_6674_(event.getHand());
            block.m_49966_().m_60734_().m_6402_(level, pos, state, (LivingEntity)player, stack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, pos, stack);
            }
            level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
            SoundType soundtype = state.getSoundType((LevelReader)level, pos, (Entity)player);
            level.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockToolModification(BlockEvent.BlockToolModificationEvent event) {
        if (event.getToolAction().equals(ToolActions.HOE_TILL) && event.getState().m_60713_((Block)VerdureBlocks.SMOOTH_DIRT.get())) {
            event.setFinalState(Blocks.f_50093_.m_49966_());
        }
    }
}

