/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.verdure.worldgen.treedecorator;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import samebutdifferent.verdure.registry.VerdureConfig;
import samebutdifferent.verdure.registry.VerdureTreeDecoratorTypes;

public class FallenLeavesDecorator
extends TreeDecorator {
    public static final Codec<FallenLeavesDecorator> CODEC = BlockState.f_61039_.fieldOf("fallen_leaves").xmap(FallenLeavesDecorator::new, decorator -> decorator.state).codec();
    private final BlockState state;

    public FallenLeavesDecorator(BlockState state) {
        this.state = state;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)VerdureTreeDecoratorTypes.FALLEN_LEAVES.get();
    }

    public void m_142741_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, Random pRandom, List<BlockPos> pLogPositions, List<BlockPos> pLeafPositions) {
        if (!pLeafPositions.isEmpty() && (double)pRandom.nextFloat() <= (Double)VerdureConfig.FALLEN_LEAVES_CHANCE.get()) {
            List<BlockPos> lowestLeafPositions = pLeafPositions.stream().filter(blockPos -> blockPos.m_123342_() == ((BlockPos)pLeafPositions.get(0)).m_123342_()).toList();
            for (BlockPos pos : lowestLeafPositions) {
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                mutable.m_122190_((Vec3i)pos.m_7495_());
                while (pLevel.m_7433_(mutable.m_7495_(), blockState -> !blockState.m_60767_().m_76333_())) {
                    mutable.m_122173_(Direction.DOWN);
                }
                if (!Feature.m_65810_((LevelSimulatedReader)pLevel, (BlockPos)mutable) || !pRandom.nextBoolean()) continue;
                pBlockSetter.accept((BlockPos)mutable, this.state);
            }
        }
    }
}

