/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked;

import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientEvents;
import com.mrcrayfish.backpacked.client.ClientHandler;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import com.mrcrayfish.backpacked.common.WanderingTraderEvents;
import com.mrcrayfish.backpacked.common.command.arguments.BackpackArgument;
import com.mrcrayfish.backpacked.common.data.PickpocketChallenge;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModBlocks;
import com.mrcrayfish.backpacked.core.ModCommands;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.core.ModEnchantments;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.core.ModSounds;
import com.mrcrayfish.backpacked.datagen.BlockTagGen;
import com.mrcrayfish.backpacked.datagen.LootTableGen;
import com.mrcrayfish.backpacked.datagen.RecipeGen;
import com.mrcrayfish.backpacked.integration.Curios;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageUpdateBackpack;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="backpacked")
public class Backpacked {
    public static final EnchantmentCategory ENCHANTMENT_TYPE = EnchantmentCategory.create((String)"backpack", item -> item instanceof BackpackItem);
    private static boolean controllableLoaded = false;
    private static boolean curiosLoaded = false;
    private static Set<ResourceLocation> bannedItemsList;
    public static final CreativeModeTab TAB;

    public Backpacked() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(ClientHandler::onRegisterLayers);
            bus.addListener(ClientHandler::onRegisterRenderers);
            bus.addListener(ClientEvents::onTextureStitch);
            bus.register((Object)ClientHandler.getModelInstances());
        });
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onClientSetup);
        bus.addListener(this::onEnqueueIMC);
        bus.addListener(this::onConfigLoad);
        bus.addListener(this::onConfigReload);
        bus.addListener(this::onGatherData);
        bus.addListener(UnlockTracker::register);
        bus.addListener(PickpocketChallenge::register);
        ModContainers.REGISTER.register(bus);
        ModEnchantments.REGISTER.register(bus);
        ModItems.REGISTER.register(bus);
        ModBlocks.REGISTER.register(bus);
        ModBlockEntities.REGISTER.register(bus);
        ModSounds.REGISTER.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ModCommands());
        MinecraftForge.EVENT_BUS.register((Object)new WanderingTraderEvents());
        controllableLoaded = ModList.get().isLoaded("controllable");
        curiosLoaded = ModList.get().isLoaded("curios");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        Network.init();
        ArgumentTypes.m_121601_((String)"backpacked:backpack", BackpackArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(BackpackArgument::backpacks));
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ClientHandler.setup();
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        if (!curiosLoaded) {
            return;
        }
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private void onGatherData(GatherDataEvent event) {
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        DataGenerator generator = event.getGenerator();
        generator.m_123914_((DataProvider)new LootTableGen(generator));
        generator.m_123914_((DataProvider)new RecipeGen(generator));
        generator.m_123914_((DataProvider)new BlockTagGen(generator, existingFileHelper));
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (curiosLoaded) {
            return;
        }
        Player oldPlayer = event.getOriginal();
        Inventory inventory = oldPlayer.m_150109_();
        if (inventory instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory1 = (ExtendedPlayerInventory)inventory;
            inventory = event.getPlayer().m_150109_();
            if (inventory instanceof ExtendedPlayerInventory) {
                ExtendedPlayerInventory inventory2 = (ExtendedPlayerInventory)inventory;
                inventory2.copyBackpack(inventory1);
            }
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        ExtendedPlayerInventory inventory;
        ItemStack backpack;
        if (curiosLoaded) {
            return;
        }
        Player player = event.getPlayer();
        Inventory inventory2 = player.m_150109_();
        if (inventory2 instanceof ExtendedPlayerInventory && !(backpack = (ItemStack)(inventory = (ExtendedPlayerInventory)inventory2).getBackpackItems().get(0)).m_41619_() && backpack.m_41720_() instanceof BackpackItem) {
            Network.getPlayChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageUpdateBackpack(player.m_142049_(), backpack));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Inventory inventory;
        if (curiosLoaded) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (!player.f_19853_.f_46443_ && (inventory = player.m_150109_()) instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory2 = (ExtendedPlayerInventory)inventory;
            if (!((ItemStack)inventory2.backpackArray.get(0)).equals(inventory2.backpackInventory.get(0))) {
                Network.getPlayChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageUpdateBackpack(player.m_142049_(), (ItemStack)inventory2.backpackInventory.get(0)));
                inventory2.backpackArray.set(0, (Object)((ItemStack)inventory2.backpackInventory.get(0)));
            }
        }
    }

    public static boolean isControllableLoaded() {
        return controllableLoaded;
    }

    public static boolean isCuriosLoaded() {
        return curiosLoaded;
    }

    public static ItemStack getBackStack(Player player) {
        ExtendedPlayerInventory inventory;
        ItemStack stack;
        Inventory inventory2;
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        if (Backpacked.isCuriosLoaded()) {
            backpack.set(Curios.getBackStack(player));
        }
        if ((inventory2 = player.m_150109_()) instanceof ExtendedPlayerInventory && !(stack = (ItemStack)(inventory = (ExtendedPlayerInventory)inventory2).getBackpackItems().get(0)).m_41619_()) {
            backpack.set(stack);
        }
        return backpack.get();
    }

    public static ItemStack getBackpackStack(Player player) {
        ExtendedPlayerInventory inventory;
        ItemStack stack;
        Inventory inventory2;
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        if (Backpacked.isCuriosLoaded()) {
            backpack.set(Curios.getBackpackStack(player));
        }
        if ((inventory2 = player.m_150109_()) instanceof ExtendedPlayerInventory && (stack = (ItemStack)(inventory = (ExtendedPlayerInventory)inventory2).getBackpackItems().get(0)).m_41720_() instanceof BackpackItem) {
            backpack.set(stack);
        }
        return backpack.get();
    }

    public static boolean setBackpackStack(Player player, ItemStack stack) {
        if (!(stack.m_41720_() instanceof BackpackItem) && !stack.m_41619_()) {
            return false;
        }
        if (Backpacked.isCuriosLoaded()) {
            Curios.setBackpackStack(player, stack);
            return true;
        }
        Inventory inventory = player.m_150109_();
        if (inventory instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory2 = (ExtendedPlayerInventory)inventory;
            inventory2.getBackpackItems().set(0, (Object)stack.m_41777_());
            return true;
        }
        return false;
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.SERVER && config.getModId().equals("backpacked")) {
            Backpacked.updateBannedItemsList();
        }
    }

    private void onConfigReload(ModConfigEvent.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.SERVER && config.getModId().equals("backpacked")) {
            Backpacked.updateBannedItemsList();
        }
    }

    public static void updateBannedItemsList() {
        bannedItemsList = ImmutableSet.copyOf((Collection)((List)Config.SERVER.bannedItems.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet()));
    }

    public static Set<ResourceLocation> getBannedItemsList() {
        return bannedItemsList;
    }

    static {
        TAB = new CreativeModeTab("backpacked"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)ModItems.BACKPACK.get());
            }
        }.m_40781_(new EnchantmentCategory[]{ENCHANTMENT_TYPE});
    }
}

