/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.keksuccino.fancymenu.commands.client.ClientExecutor;
import de.keksuccino.fancymenu.commands.client.CommandUtils;
import de.keksuccino.fancymenu.menu.variables.VariableHandler;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.command.commands.variable.VariableCommandSuggestionsPacketMessage;
import de.keksuccino.konkrete.localization.Locals;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VariableCommand {
    protected static Screen lastScreen = null;
    protected static boolean initialized = false;

    public static void register(CommandDispatcher<CommandSourceStack> d) {
        if (!initialized) {
            MinecraftForge.EVENT_BUS.register((Object)new VariableCommand());
            initialized = true;
        }
        d.register((LiteralArgumentBuilder)Commands.m_82127_((String)"fmvariable").then(Commands.m_82129_((String)"action", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandUtils.getStringSuggestions(builder, "get", "set")).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"variable_name", (ArgumentType)StringArgumentType.string()).executes(stack -> VariableCommand.getVariable((CommandSourceStack)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"action"), StringArgumentType.getString((CommandContext)stack, (String)"variable_name")))).suggests((context, builder) -> CommandUtils.getStringSuggestions(builder, VariableCommand.getVariableNameSuggestions())).then(Commands.m_82129_((String)"set_to_value", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            if (StringArgumentType.getString((CommandContext)context, (String)"action").equalsIgnoreCase("set")) {
                return CommandUtils.getStringSuggestions(builder, "<set_to_value>");
            }
            return CommandUtils.getStringSuggestions(builder, new String[0]);
        }).then(Commands.m_82129_((String)"send_chat_feedback", (ArgumentType)BoolArgumentType.bool()).executes(stack -> VariableCommand.setVariable((CommandSourceStack)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"action"), StringArgumentType.getString((CommandContext)stack, (String)"variable_name"), StringArgumentType.getString((CommandContext)stack, (String)"set_to_value"), BoolArgumentType.getBool((CommandContext)stack, (String)"send_chat_feedback"))))))));
    }

    private static String[] getVariableNameSuggestions() {
        List<String> l = VariableHandler.getVariableNames();
        if (l.isEmpty()) {
            l.add("<no_variables_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int getVariable(CommandSourceStack stack, String getOrSet, String variableName) {
        ClientExecutor.execute(() -> {
            try {
                if (getOrSet.equalsIgnoreCase("get")) {
                    String s = VariableHandler.getVariable(variableName);
                    if (s != null) {
                        stack.m_81354_((Component)new TextComponent(Locals.localize((String)"fancymenu.commands.variable.get.success", (String[])new String[]{s})), false);
                    } else {
                        stack.m_81352_((Component)new TextComponent(Locals.localize((String)"fancymenu.commands.variable.not_found", (String[])new String[0])));
                    }
                }
            }
            catch (Exception e) {
                stack.m_81352_((Component)new TextComponent("Error while executing command!"));
                e.printStackTrace();
            }
        });
        return 1;
    }

    private static int setVariable(CommandSourceStack stack, String getOrSet, String variableName, String setToValue, boolean sendFeedback) {
        ClientExecutor.execute(() -> {
            try {
                if (getOrSet.equalsIgnoreCase("set")) {
                    VariableHandler.setVariable(variableName, setToValue);
                    if (sendFeedback) {
                        stack.m_81354_((Component)new TextComponent(Locals.localize((String)"fancymenu.commands.variable.set.success", (String[])new String[]{setToValue})), false);
                    }
                }
            }
            catch (Exception e) {
                stack.m_81352_((Component)new TextComponent("Error while executing command!"));
                e.printStackTrace();
            }
        });
        return 1;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (s instanceof ChatScreen && (lastScreen == null || lastScreen != s)) {
            VariableCommandSuggestionsPacketMessage msg = new VariableCommandSuggestionsPacketMessage();
            msg.direction = "server";
            msg.variableNameSuggestions.addAll(Arrays.asList(VariableCommand.getVariableNameSuggestions()));
            PacketHandler.sendToServer(msg);
        }
        lastScreen = s;
    }
}

