/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button.identification;

import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.button.identification.identificationcontext.DeathScreenButtonsIdentificationContext;
import de.keksuccino.fancymenu.menu.button.identification.identificationcontext.MenuButtonsIdentificationContext;
import de.keksuccino.fancymenu.menu.button.identification.identificationcontext.PauseScreenButtonsIdentificationContext;
import de.keksuccino.fancymenu.menu.button.identification.identificationcontext.TitleScreenButtonsIdentificationContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ButtonIdentificator {
    private static final Logger LOGGER = LogManager.getLogger((String)"fancymenu/ButtonIdentificator");
    private static Map<Class, MenuButtonsIdentificationContext> contexts = new HashMap<Class, MenuButtonsIdentificationContext>();

    public static void init() {
        ButtonIdentificator.registerContext(new TitleScreenButtonsIdentificationContext());
        ButtonIdentificator.registerContext(new DeathScreenButtonsIdentificationContext());
        ButtonIdentificator.registerContext(new PauseScreenButtonsIdentificationContext());
    }

    public static void registerContext(MenuButtonsIdentificationContext context) {
        contexts.put(context.getMenu(), context);
    }

    public static String getCompatibilityIdentifierForButton(ButtonData data) {
        try {
            MenuButtonsIdentificationContext c;
            Screen s = data.getScreen();
            if (s != null && (c = contexts.get(s.getClass())) != null) {
                return c.getCompatibilityIdentifierForButton(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setCompatibilityIdentifierToData(ButtonData data) {
        if (data != null) {
            data.setCompatibilityId(ButtonIdentificator.getCompatibilityIdentifierForButton(data));
        }
    }
}

