/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.gui.effects;

import com.google.common.collect.Lists;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.PotionUtils;

public class ColorUtil {
    public static int getEffectColor(ChatFormatting color, MobEffectInstance effectinstance) {
        if (color != null) {
            return color.m_126665_();
        }
        return ColorUtil.brightenColor(PotionUtils.m_43564_((Collection)Lists.newArrayList((Object[])new MobEffectInstance[]{effectinstance})));
    }

    private static int brightenColor(int potionColor) {
        int red = potionColor >> 16 & 0xFF;
        int green = potionColor >> 8 & 0xFF;
        int blue = potionColor & 0xFF;
        if (red + green + blue < 128) {
            int min = Math.min(red, Math.min(green, blue));
            int increase = 128 - min;
            int[] color = new int[]{red + increase, green + increase, blue + increase};
            ColorUtil.redistributeColors(color);
            return color[0] << 16 | color[1] << 8 | color[0];
        }
        return potionColor;
    }

    private static void redistributeColors(int[] color) {
        int max = Math.max(color[0], Math.max(color[1], color[2]));
        if (max > 255) {
            int total = color[0] + color[1] + color[2];
            if (total > 765) {
                color[2] = 255;
                color[1] = 255;
                color[0] = 255;
            } else {
                int x = (765 - total) / (3 * max - total);
                int gray = 255 - x * max;
                color[0] = gray + x * color[0];
                color[1] = gray + x * color[1];
                color[2] = gray + x * color[2];
            }
        }
    }
}

