/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.gui.effects;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.client.gui.effects.AbstractEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.ColorUtil;
import fuzs.stylisheffects.config.ClientConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import org.apache.commons.lang3.tuple.Pair;

public class CompactEffectRenderer
extends AbstractEffectRenderer {
    private static final ResourceLocation TINY_NUMBERS_TEXTURE = new ResourceLocation("stylisheffects", "textures/font/tiny_numbers.png");

    public CompactEffectRenderer(AbstractEffectRenderer.EffectRendererType type) {
        super(type);
    }

    @Override
    public int getWidth() {
        return 29;
    }

    @Override
    public int getHeight() {
        return 24;
    }

    @Override
    public int getRows() {
        if (((ClientConfig)StylishEffects.CONFIG.client()).compactWidget().separateEffects) {
            int beneficialEffects = this.getBeneficialAmount(this.activeEffects);
            return this.splitByColumns(beneficialEffects) + this.splitByColumns(this.activeEffects.size() - beneficialEffects);
        }
        return super.getRows();
    }

    @Override
    protected int getTopOffset() {
        return 1;
    }

    private int getBeneficialAmount(List<MobEffectInstance> activeEffects) {
        return (int)activeEffects.stream().map(MobEffectInstance::m_19544_).filter(MobEffect::m_19486_).count();
    }

    @Override
    public List<Pair<MobEffectInstance, int[]>> getEffectPositions(List<MobEffectInstance> activeEffects) {
        int beneficialRows = this.splitByColumns(this.getBeneficialAmount(activeEffects));
        int beneficialCounter = 0;
        int harmfulCounter = 0;
        ArrayList effectToPos = Lists.newArrayList();
        for (MobEffectInstance effect : activeEffects) {
            boolean beneficial = !((ClientConfig)StylishEffects.CONFIG.client()).compactWidget().separateEffects || effect.m_19544_().m_19486_();
            int counter = beneficial ? beneficialCounter++ : harmfulCounter++;
            int posX = counter % this.getMaxClampedColumns();
            int posY = counter / this.getMaxClampedColumns();
            if (!beneficial) {
                posY += beneficialRows;
            }
            if (this.config().overflowMode == ClientConfig.OverflowMode.SKIP && posY >= this.getMaxClampedRows()) continue;
            effectToPos.add(Pair.of((Object)effect, (Object)this.coordsToEffectPosition(posX, posY)));
        }
        if (((ClientConfig)StylishEffects.CONFIG.client()).compactWidget().separateEffects) {
            effectToPos.sort(Comparator.comparing(o -> ((MobEffectInstance)o.getLeft()).m_19544_().m_19486_()).reversed());
        }
        if (beneficialCounter + harmfulCounter != activeEffects.size()) {
            throw new RuntimeException("effects amount mismatch");
        }
        return effectToPos;
    }

    @Override
    public void renderWidget(PoseStack matrixStack, int posX, int posY, Minecraft minecraft, MobEffectInstance effectinstance) {
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)EFFECT_BACKGROUND);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.config().widgetAlpha));
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)posX, (int)posY, (float)(((ClientConfig)StylishEffects.CONFIG.client()).compactWidget().ambientBorder && effectinstance.m_19571_() ? (float)this.getWidth() : 0.0f), (float)64.0f, (int)this.getWidth(), (int)this.getHeight(), (int)256, (int)256);
        this.drawEffectAmplifier(matrixStack, posX, posY, minecraft, effectinstance);
        this.drawEffectSprite(matrixStack, posX, posY, minecraft, effectinstance);
        this.drawCustomEffect(matrixStack, posX, posY, effectinstance);
        this.drawEffectText(matrixStack, posX, posY, minecraft, effectinstance);
    }

    private void drawEffectAmplifier(PoseStack matrixStack, int posX, int posY, Minecraft minecraft, MobEffectInstance effectinstance) {
        ClientConfig.EffectAmplifier amplifier = ((ClientConfig)StylishEffects.CONFIG.client()).compactWidget().effectAmplifier;
        if (amplifier != ClientConfig.EffectAmplifier.NONE && effectinstance.m_19564_() >= 1 && effectinstance.m_19564_() <= 9) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TINY_NUMBERS_TEXTURE);
            int potionColor = ColorUtil.getEffectColor(((ClientConfig)StylishEffects.CONFIG.client()).compactWidget().amplifierColor, effectinstance);
            float red = (float)(potionColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(potionColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(potionColor >> 0 & 0xFF) / 255.0f;
            int offsetX = amplifier == ClientConfig.EffectAmplifier.TOP_LEFT ? 3 : 23;
            int offsetY = 2;
            RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)((float)this.config().widgetAlpha));
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)(posX + offsetX - 1), (int)(posY + 2), (float)(5 * (effectinstance.m_19564_() + 1)), (float)0.0f, (int)3, (int)5, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)(posX + offsetX + 1), (int)(posY + 2), (float)(5 * (effectinstance.m_19564_() + 1)), (float)0.0f, (int)3, (int)5, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)(posX + offsetX), (int)(posY + 2 - 1), (float)(5 * (effectinstance.m_19564_() + 1)), (float)0.0f, (int)3, (int)5, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)(posX + offsetX), (int)(posY + 2 + 1), (float)(5 * (effectinstance.m_19564_() + 1)), (float)0.0f, (int)3, (int)5, (int)256, (int)256);
            RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)((float)this.config().widgetAlpha));
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)(posX + offsetX), (int)(posY + 2), (float)(5 * (effectinstance.m_19564_() + 1)), (float)0.0f, (int)3, (int)5, (int)256, (int)256);
        }
    }

    private void drawEffectSprite(PoseStack matrixStack, int posX, int posY, Minecraft minecraft, MobEffectInstance effectinstance) {
        MobEffectTextureManager potionspriteuploader = minecraft.m_91306_();
        TextureAtlasSprite textureatlassprite = potionspriteuploader.m_118732_(effectinstance.m_19544_());
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
        float blinkingAlpha = ((ClientConfig)StylishEffects.CONFIG.client()).compactWidget().blinkingAlpha ? this.getBlinkingAlpha(effectinstance) : 1.0f;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(blinkingAlpha * (float)this.config().widgetAlpha));
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)(posX + 5), (int)(posY + (!((ClientConfig)StylishEffects.CONFIG.client()).compactWidget().ambientDuration && effectinstance.m_19571_() ? 3 : 2)), (int)0, (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
    }

    private void drawEffectText(PoseStack matrixStack, int posX, int posY, Minecraft minecraft, MobEffectInstance effectinstance) {
        if (((ClientConfig)StylishEffects.CONFIG.client()).compactWidget().ambientDuration || !effectinstance.m_19571_()) {
            this.getEffectDuration(effectinstance, ((ClientConfig)StylishEffects.CONFIG.client()).compactWidget().longDurationString).ifPresent(durationComponent -> {
                int potionColor = ColorUtil.getEffectColor(((ClientConfig)StylishEffects.CONFIG.client()).compactWidget().durationColor, effectinstance);
                int alpha = (int)(this.config().widgetAlpha * 255.0) << 24;
                FormattedCharSequence ireorderingprocessor = durationComponent.m_7532_();
                minecraft.f_91062_.m_92877_(matrixStack, ireorderingprocessor, (float)(posX + 14 - minecraft.f_91062_.m_92724_(ireorderingprocessor) / 2), (float)(posY + 14), alpha);
                minecraft.f_91062_.m_92877_(matrixStack, ireorderingprocessor, (float)(posX + 16 - minecraft.f_91062_.m_92724_(ireorderingprocessor) / 2), (float)(posY + 14), alpha);
                minecraft.f_91062_.m_92877_(matrixStack, ireorderingprocessor, (float)(posX + 15 - minecraft.f_91062_.m_92724_(ireorderingprocessor) / 2), (float)(posY + 13), alpha);
                minecraft.f_91062_.m_92877_(matrixStack, ireorderingprocessor, (float)(posX + 15 - minecraft.f_91062_.m_92724_(ireorderingprocessor) / 2), (float)(posY + 15), alpha);
                minecraft.f_91062_.m_92877_(matrixStack, ireorderingprocessor, (float)(posX + 15 - minecraft.f_91062_.m_92724_(ireorderingprocessor) / 2), (float)(posY + 14), alpha | potionColor);
            });
        }
    }
}

