/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.entities.ai.copper_golem.task;

import com.cursedcauldron.unvotedandshelved.block.CopperButtonBlock;
import com.cursedcauldron.unvotedandshelved.entities.CopperGolemEntity;
import com.cursedcauldron.unvotedandshelved.init.USMemoryModules;
import com.cursedcauldron.unvotedandshelved.init.USPoses;
import com.cursedcauldron.unvotedandshelved.init.USSoundEvents;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class PressCopperButtonTask
extends Behavior<CopperGolemEntity> {
    private int buttonTicks;

    public PressCopperButtonTask() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel world, CopperGolemEntity entity) {
        return entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get()).isPresent() && entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS.get()).isEmpty();
    }

    protected boolean canStillUse(ServerLevel world, CopperGolemEntity entity, long p_22547_) {
        return entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get()).isPresent() && entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS.get()).isEmpty();
    }

    protected void start(ServerLevel world, CopperGolemEntity entity, long p_22542_) {
        Optional optional = entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get());
        optional.ifPresent(blockPos -> {
            Block patt2261$temp;
            BlockState state = entity.f_19853_.m_8055_(blockPos);
            boolean flag = entity.m_142538_().m_123314_((Vec3i)blockPos, 2.0);
            if (flag && (patt2261$temp = state.m_60734_()) instanceof CopperButtonBlock) {
                CopperButtonBlock buttonBlock = (CopperButtonBlock)patt2261$temp;
                AttachFace direction = (AttachFace)state.m_61143_((Property)CopperButtonBlock.f_53179_);
                entity.m_21563_().m_24946_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                entity.m_20124_(switch (direction) {
                    case AttachFace.FLOOR -> USPoses.PRESS_BUTTON_DOWN.get();
                    case AttachFace.CEILING -> USPoses.PRESS_BUTTON_UP.get();
                    default -> USPoses.PRESS_BUTTON.get();
                });
                buttonBlock.m_51116_(state, (Level)world, (BlockPos)blockPos);
                world.m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (SoundEvent)USSoundEvents.COPPER_CLICK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        });
    }

    protected void tick(ServerLevel level, CopperGolemEntity entity, long p_22553_) {
        if (this.buttonTicks < 60) {
            ++this.buttonTicks;
        } else {
            entity.m_6274_().m_21936_((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get());
            entity.m_6274_().m_21879_((MemoryModuleType)USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS.get(), (Object)UniformInt.m_146622_((int)120, (int)240).m_142270_(level.m_5822_()));
            entity.m_20124_(Pose.STANDING);
        }
    }

    protected void stop(ServerLevel world, CopperGolemEntity entity, long p_22550_) {
        if (this.buttonTicks >= 1) {
            this.buttonTicks = 0;
            entity.m_20124_(Pose.STANDING);
        }
    }
}

