/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.entities.ai.glare;

import com.cursedcauldron.unvotedandshelved.entities.GlareEntity;
import com.cursedcauldron.unvotedandshelved.entities.ai.glare.task.AerialStrollTask;
import com.cursedcauldron.unvotedandshelved.entities.ai.glare.task.GlowberryStrollTask;
import com.cursedcauldron.unvotedandshelved.init.USActivities;
import com.cursedcauldron.unvotedandshelved.init.USMemoryModules;
import com.cursedcauldron.unvotedandshelved.init.USSoundEvents;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class GlareBrain {
    public static Brain<?> create(Brain<GlareEntity> brain) {
        GlareBrain.addCoreActivities(brain);
        GlareBrain.addFindDarknessActivity(brain);
        GlareBrain.addIdleActivities(brain);
        brain.m_21879_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get(), (Object)0);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void addCoreActivities(Brain<GlareEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static Vec3 getRandomNearbyPos(GlareEntity glare) {
        Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)glare, (int)4, (int)2);
        return vec3 == null ? glare.m_20182_() : vec3;
    }

    public static boolean isGlowBerry(ItemStack stack) {
        return stack.m_150930_(Items.f_151079_);
    }

    public static InteractionResult playerInteract(GlareEntity glare, Player player, InteractionHand hand) {
        int i;
        Brain<GlareEntity> brain = glare.m_6274_();
        ItemStack itemStack = player.m_21120_(hand);
        if (brain.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).isPresent() && (i = ((Integer)brain.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).get()).intValue()) < 5 && GlareBrain.isGlowBerry(itemStack)) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
                brain.m_21879_((MemoryModuleType)USMemoryModules.GIVEN_GLOWBERRY.get(), (Object)glare);
            }
            if (brain.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).isPresent()) {
                glare.setGlowberries(i + 1);
                glare.m_5496_((SoundEvent)USSoundEvents.GLARE_GIVE_GLOW_BERRIES.get(), 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (brain.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).isPresent()) {
                glare.setGlowberries(i + 1);
                glare.m_5496_((SoundEvent)USSoundEvents.GLARE_GIVE_GLOW_BERRIES.get(), 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        glare.m_21530_();
        return InteractionResult.CONSUME;
    }

    private static void addFindDarknessActivity(Brain<GlareEntity> brain) {
        brain.m_21907_((Activity)USActivities.GOTO_DARKNESS.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new GlowberryStrollTask(20, 0.6f)))), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)USMemoryModules.GIVEN_GLOWBERRY.get()), (Object)MemoryStatus.VALUE_PRESENT)), (Set)ImmutableSet.of((Object)((MemoryModuleType)USMemoryModules.GIVEN_GLOWBERRY.get())));
    }

    public static void addIdleActivities(Brain<GlareEntity> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)5, (int)10))), (Object)Pair.of((Object)2, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)((Object)new AerialStrollTask(0.6f)), (Object)2), (Object)Pair.of((Object)new RandomStroll(0.6f), (Object)2), (Object)Pair.of((Object)((Object)new GlowberryStrollTask(10, 0.6f)), (Object)2), (Object)Pair.of((Object)new RunIf(GlareEntity::m_142592_, (Behavior)new DoNothing(10, 20)), (Object)5), (Object)Pair.of((Object)new RunIf(Entity::m_20096_, (Behavior)new DoNothing(10, 20)), (Object)5))))));
    }

    public static void updateActivities(GlareEntity glare) {
        Brain<GlareEntity> brain = glare.m_6274_();
        brain.m_21926_((List)ImmutableList.of((Object)((Activity)USActivities.GOTO_DARKNESS.get()), (Object)Activity.f_37979_));
    }
}

