/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.entities.ai.glare.task;

import com.cursedcauldron.unvotedandshelved.entities.GlareEntity;
import com.cursedcauldron.unvotedandshelved.init.USMemoryModules;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class GlowberryStrollTask
extends Behavior<GlareEntity> {
    private BlockPos darkPos;
    private final int range;
    private final float speed;
    protected GroundPathNavigation groundNavigation;

    public GlowberryStrollTask(int range, float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_PRESENT));
        this.range = range;
        this.speed = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, GlareEntity entity) {
        return !entity.m_20072_() && (Integer)entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).get() >= 1;
    }

    protected boolean canStillUse(ServerLevel p_22545_, GlareEntity glare, long p_22547_) {
        return (Integer)glare.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).get() >= 1 && this.darkPos != null;
    }

    private boolean pathfindDirectlyTowards(BlockPos blockPos, GlareEntity entity) {
        entity.m_21573_().m_26519_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 1.0);
        return entity.m_21573_().m_26570_() != null && entity.m_21573_().m_26570_().m_77403_();
    }

    private boolean isValidSpawnPos(BlockPos blockPos, ServerLevel level) {
        return !level.m_8055_(blockPos).m_60713_(Blocks.f_50191_) && !level.m_8055_(blockPos).m_204336_(BlockTags.f_13035_) && !level.m_8055_(blockPos).m_204336_(BlockTags.f_144275_) && !level.m_8055_(blockPos).m_60795_() && !level.m_6425_(blockPos).m_192917_((Fluid)Fluids.f_76193_) && !level.m_6425_(blockPos).m_192917_((Fluid)Fluids.f_76192_);
    }

    protected void getDarkPos(ServerLevel level, GlareEntity glare) {
        if (this.darkPos == null) {
            for (int x = this.getRandomNumber(0, -this.range); x <= this.getRandomNumber(0, this.range); ++x) {
                for (int z = this.getRandomNumber(0, -this.range); z <= this.getRandomNumber(0, this.range); ++z) {
                    for (int y = this.getRandomNumber(0, -this.range); y <= this.getRandomNumber(0, this.range); ++y) {
                        BlockPos entityPos = glare.m_142538_();
                        BlockPos blockPos2 = new BlockPos(entityPos.m_123341_() + x, entityPos.m_123342_() + y, entityPos.m_123343_() + z);
                        BlockPos spacePos = blockPos2.m_7495_();
                        BlockPos groundPos = spacePos.m_7495_();
                        if (!level.m_46739_(blockPos2) || !this.isValidSpawnPos(groundPos, level) || !level.m_46859_(spacePos) || !level.m_46859_(blockPos2) || !level.m_8055_(blockPos2).m_60647_((BlockGetter)level, blockPos2, PathComputationType.LAND) || !(level.m_45517_(LightLayer.BLOCK, blockPos2) == 0 && level.m_45517_(LightLayer.SKY, blockPos2) == 0 || level.m_45517_(LightLayer.BLOCK, blockPos2) == 0 && level.m_46462_()) && (level.m_45517_(LightLayer.BLOCK, blockPos2) != 0 || !level.m_46470_())) continue;
                        glare.m_6274_().m_21879_((MemoryModuleType)USMemoryModules.DARK_POS.get(), (Object)blockPos2);
                        this.darkPos = blockPos2;
                        return;
                    }
                }
            }
        }
    }

    public int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    private static int getRandomOffset(Random random) {
        return random.nextInt(3) - 1;
    }

    private static BlockPos getNearbyPos(GlareEntity mob, BlockPos blockPos) {
        Random random = mob.f_19853_.f_46441_;
        return blockPos.m_142082_(GlowberryStrollTask.getRandomOffset(random), 0, GlowberryStrollTask.getRandomOffset(random));
    }

    protected void tick(ServerLevel level, GlareEntity entity, long time) {
        super.m_6725_(level, (LivingEntity)entity, time);
        if (this.darkPos != null) {
            Brain<GlareEntity> brain = entity.m_6274_();
            BlockPos groundPos = this.darkPos.m_7495_().m_7495_();
            if (level.m_46739_(this.darkPos) && level.m_8055_(this.darkPos).m_60795_() && !level.m_8055_(groundPos).m_60795_() && level.m_46859_(this.darkPos) && level.m_8055_(this.darkPos).m_60647_((BlockGetter)level, this.darkPos, PathComputationType.LAND) && (level.m_45517_(LightLayer.BLOCK, this.darkPos) == 0 && level.m_45517_(LightLayer.SKY, this.darkPos) == 0 || level.m_45517_(LightLayer.BLOCK, this.darkPos) == 0 && level.m_46462_() || level.m_45517_(LightLayer.BLOCK, this.darkPos) == 0 && level.m_46470_())) {
                int i = (Integer)brain.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).get();
                if (brain.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).isPresent()) {
                    boolean bl = this.pathfindDirectlyTowards(this.darkPos, entity);
                    if (bl) {
                        BlockPos blockPos = new BlockPos(this.darkPos.m_123341_(), this.darkPos.m_123342_(), this.darkPos.m_123343_());
                        BehaviorUtils.m_22617_((LivingEntity)entity, (BlockPos)GlowberryStrollTask.getNearbyPos(entity, blockPos), (float)this.speed, (int)3);
                        if (entity.m_142538_().m_123314_((Vec3i)this.darkPos, 3.0)) {
                            entity.setLightblock(blockPos);
                            entity.setGlowberries(i - 1);
                            this.darkPos = null;
                        }
                    } else {
                        this.darkPos = null;
                    }
                }
            } else {
                this.darkPos = null;
            }
        }
    }

    protected void stop(ServerLevel level, GlareEntity entity, long time) {
        if (this.darkPos != null) {
            Brain<GlareEntity> brain = entity.m_6274_();
            BlockPos entityPos = entity.m_142538_();
            BlockPos groundPos = this.darkPos.m_7495_().m_7495_();
            if (level.m_46739_(this.darkPos) && level.m_8055_(this.darkPos).m_60795_() && !level.m_8055_(groundPos).m_60795_() && level.m_46859_(this.darkPos) && level.m_8055_(this.darkPos).m_60647_((BlockGetter)level, this.darkPos, PathComputationType.LAND) && (level.m_45517_(LightLayer.BLOCK, this.darkPos) == 0 && level.m_45517_(LightLayer.SKY, this.darkPos) == 0 || level.m_45517_(LightLayer.BLOCK, this.darkPos) == 0 && level.m_46462_() || level.m_45517_(LightLayer.BLOCK, this.darkPos) == 0 && level.m_46470_())) {
                int i = (Integer)brain.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).get();
                if (brain.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).isPresent()) {
                    boolean bl = this.pathfindDirectlyTowards(this.darkPos, entity);
                    if (bl) {
                        BlockPos blockPos = new BlockPos(this.darkPos.m_123341_(), this.darkPos.m_123342_(), this.darkPos.m_123343_());
                        BehaviorUtils.m_22617_((LivingEntity)entity, (BlockPos)GlowberryStrollTask.getNearbyPos(entity, blockPos), (float)this.speed, (int)3);
                        if (entity.m_142538_().m_123314_((Vec3i)this.darkPos, 3.0)) {
                            entity.setLightblock(blockPos);
                            entity.setGlowberries(i - 1);
                            this.darkPos = null;
                        }
                    } else {
                        this.darkPos = null;
                    }
                }
            } else {
                this.darkPos = null;
            }
        }
    }

    protected void start(ServerLevel level, GlareEntity entity, long time) {
        this.groundNavigation = new GroundPathNavigation((Mob)entity, (Level)level);
        this.getDarkPos(level, entity);
        if (this.darkPos != null) {
            Brain<GlareEntity> brain = entity.m_6274_();
            BlockPos entityPos = entity.m_142538_();
            BlockPos groundPos = this.darkPos.m_7495_().m_7495_();
            if (level.m_46739_(this.darkPos) && level.m_8055_(this.darkPos).m_60795_() && !level.m_8055_(groundPos).m_60795_() && level.m_46859_(this.darkPos) && level.m_8055_(this.darkPos).m_60647_((BlockGetter)level, this.darkPos, PathComputationType.LAND) && (level.m_45517_(LightLayer.BLOCK, this.darkPos) == 0 && level.m_45517_(LightLayer.SKY, this.darkPos) == 0 || level.m_45517_(LightLayer.BLOCK, this.darkPos) == 0 && level.m_46462_() || level.m_45517_(LightLayer.BLOCK, this.darkPos) == 0 && level.m_46470_())) {
                int i = (Integer)brain.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).get();
                if (brain.m_21952_((MemoryModuleType)USMemoryModules.GLOWBERRIES_GIVEN.get()).isPresent()) {
                    boolean bl = this.pathfindDirectlyTowards(this.darkPos, entity);
                    if (bl) {
                        BlockPos blockPos = new BlockPos(this.darkPos.m_123341_(), this.darkPos.m_123342_(), this.darkPos.m_123343_());
                        BehaviorUtils.m_22617_((LivingEntity)entity, (BlockPos)GlowberryStrollTask.getNearbyPos(entity, blockPos), (float)this.speed, (int)3);
                        if (entity.m_142538_().m_123314_((Vec3i)this.darkPos, 3.0)) {
                            entity.setLightblock(blockPos);
                            entity.setGlowberries(i - 1);
                            this.darkPos = null;
                        }
                    } else {
                        this.darkPos = null;
                    }
                }
            } else {
                this.darkPos = null;
            }
        }
    }
}

