/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.type.RGBA;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public final class ComputedProperties {
    private final Minecraft mc;
    private final CustomCrosshair crosshair;
    private final int gap;
    private final RGBA colour;
    private final boolean isVisible;
    private final Set<Item> rangedWeapons = ImmutableSet.of((Object)Items.f_42411_, (Object)Items.f_42713_, (Object)Items.f_42717_);
    private final Set<Item> throwableItems = ImmutableSet.of((Object)Items.f_42584_, (Object)Items.f_42545_);
    private final Map<Item, Float> usageItemsDurations = ImmutableMap.of((Object)Items.f_42411_, (Object)Float.valueOf(20.0f), (Object)Items.f_42713_, (Object)Float.valueOf(10.0f), (Object)Items.f_42717_, (Object)Float.valueOf(0.0f));

    public ComputedProperties(CustomCrosshair crosshair) {
        this.mc = Minecraft.m_91087_();
        this.crosshair = crosshair;
        this.gap = this.calculateGap();
        this.colour = this.calculateColour();
        this.isVisible = this.calculateIsVisible();
    }

    public int gap() {
        return this.gap;
    }

    public RGBA colour() {
        return this.colour;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    private int calculateGap() {
        int baseGap = (Integer)this.crosshair.gap.get();
        if (this.mc.f_91074_ == null) {
            return baseGap;
        }
        boolean isSpectator = this.mc.f_91074_.m_5833_();
        ItemStack mainHandItem = this.mc.f_91074_.m_21205_();
        boolean isHoldingItem = !mainHandItem.m_41619_() || !this.mc.f_91074_.m_21206_().m_41619_();
        boolean isDynamicBowEnabled = (Boolean)this.crosshair.isDynamicBowEnabled.get();
        boolean isDynamicAttackIndicatorEnabled = (Boolean)this.crosshair.isDynamicAttackIndicatorEnabled.get();
        if (isSpectator || !isHoldingItem || !isDynamicAttackIndicatorEnabled && !isDynamicBowEnabled) {
            return baseGap;
        }
        int gapModifier = 2;
        Float usageItemDuration = this.usageItemsDurations.get(this.mc.f_91074_.m_21211_().m_41720_());
        if (isDynamicBowEnabled && usageItemDuration != null) {
            float progress;
            if (this.mc.f_91074_.m_21211_().m_41720_() == Items.f_42717_) {
                usageItemDuration = Float.valueOf(CrossbowItem.m_40939_((ItemStack)this.mc.f_91074_.m_21211_()));
                progress = Math.min(usageItemDuration.floatValue(), (float)this.mc.f_91074_.m_21252_());
            } else {
                progress = Math.min(usageItemDuration.floatValue(), (float)this.mc.f_91074_.m_21252_());
            }
            return baseGap + Math.round((usageItemDuration.floatValue() - progress) * (float)gapModifier);
        }
        if (isDynamicAttackIndicatorEnabled) {
            boolean hasAttackSpeedModifier = mainHandItem.m_41720_().getAttributeModifiers(EquipmentSlot.MAINHAND, mainHandItem).entries().stream().anyMatch(x -> ((Attribute)x.getKey()).equals(Attributes.f_22283_));
            if (!hasAttackSpeedModifier) {
                return baseGap;
            }
            float currentAttackUsage = this.mc.f_91074_.m_36403_(0.0f);
            float maxAttackUsage = 1.0f;
            if (this.mc.f_91074_.m_36333_() > 5.0f && currentAttackUsage < maxAttackUsage) {
                return baseGap + Math.round((maxAttackUsage - currentAttackUsage) * (float)gapModifier * 20.0f);
            }
        }
        return baseGap;
    }

    private RGBA calculateColour() {
        Entity target = this.mc.f_91076_;
        boolean isHighlightPlayersEnabled = (Boolean)this.crosshair.isHighlightPlayersEnabled.get();
        if (isHighlightPlayersEnabled && target instanceof Player) {
            return (RGBA)this.crosshair.highlightPlayersColour.get();
        }
        boolean isHighlightHostilesEnabled = (Boolean)this.crosshair.isHighlightHostilesEnabled.get();
        if (isHighlightHostilesEnabled && target instanceof Enemy) {
            return (RGBA)this.crosshair.highlightHostilesColour.get();
        }
        boolean isHighlightPassivesEnabled = (Boolean)this.crosshair.isHighlightPassivesEnabled.get();
        if (isHighlightPassivesEnabled && target instanceof LivingEntity) {
            return (RGBA)this.crosshair.highlightPassivesColour.get();
        }
        if (((Boolean)this.crosshair.isRainbowEnabled.get()).booleanValue()) {
            return this.getRainbowColour();
        }
        return (RGBA)this.crosshair.colour.get();
    }

    private RGBA getRainbowColour() {
        int ticks = (Integer)this.crosshair.rainbowTicks.get() + 1;
        if (ticks > 125000) {
            ticks = 0;
        }
        this.crosshair.rainbowTicks.set(ticks);
        int opacity = ((RGBA)this.crosshair.colour.get()).getOpacity();
        int speed = (Integer)this.crosshair.rainbowSpeed.get();
        return new RGBA(255, 255, 255, opacity).setRed(this.getRainbowColourComponent(ticks, 0.0f, speed)).setGreen(this.getRainbowColourComponent(ticks, 2.0f, speed)).setBlue(this.getRainbowColourComponent(ticks, 4.0f, speed));
    }

    private int getRainbowColourComponent(int ticks, float offset, int speed) {
        return (int)(Math.sin((float)(ticks * speed) / 20000.0f + offset) * 127.0 + 128.0);
    }

    private boolean calculateIsVisible() {
        boolean isThirdPerson;
        if (this.mc.f_91074_ == null) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleDefault.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleHiddenGui.get()).booleanValue() && this.mc.f_91066_.f_92062_) {
            return false;
        }
        boolean bl = isThirdPerson = !this.mc.f_91066_.m_92176_().m_90612_();
        if (!((Boolean)this.crosshair.isVisibleThirdPerson.get()).booleanValue() && isThirdPerson) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleDebug.get()).booleanValue() && this.mc.f_91066_.f_92063_) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleSpectator.get()).booleanValue() && this.mc.f_91074_.m_5833_()) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleHoldingRangedWeapon.get()).booleanValue() && this.isHoldingItem((Player)this.mc.f_91074_, this.rangedWeapons)) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleHoldingThrowableItem.get()).booleanValue() && this.isHoldingItem((Player)this.mc.f_91074_, this.throwableItems)) {
            return false;
        }
        return (Boolean)this.crosshair.isVisibleUsingSpyglass.get() != false || !this.mc.f_91074_.m_150108_();
    }

    private boolean isHoldingItem(Player player, Set<Item> items) {
        ItemStack mainHandItem = player.m_21205_();
        boolean isMainHand = items.contains(mainHandItem.m_41720_());
        boolean isOffhand = items.contains(player.m_21206_().m_41720_());
        return isMainHand || isOffhand && mainHandItem.m_41619_();
    }
}

