/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.cherishedworlds.client.favorites;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.client.event.ScreenEvent;
import top.theillusivec4.cherishedworlds.CherishedWorldsMod;
import top.theillusivec4.cherishedworlds.client.favorites.FavoritesList;
import top.theillusivec4.cherishedworlds.client.favorites.IFavoritesManager;
import top.theillusivec4.cherishedworlds.mixin.core.WorldSelectionListEntryAccessor;
import top.theillusivec4.cherishedworlds.mixin.core.WorldSelectionScreenAccessor;

public class FavoriteWorlds
implements IFavoritesManager<SelectWorldScreen> {
    @Override
    public void init(SelectWorldScreen screen) {
        WorldSelectionScreenAccessor accessor = (WorldSelectionScreenAccessor)screen;
        WorldSelectionList selectionList = accessor.getList();
        if (selectionList != null) {
            EditBox textField = accessor.getSearchBox();
            if (textField != null) {
                textField.m_94151_(s -> FavoriteWorlds.refreshList(selectionList, () -> s));
            }
            FavoriteWorlds.refreshList(selectionList);
        }
    }

    @Override
    public void draw(ScreenEvent.DrawScreenEvent.Post evt, SelectWorldScreen screen) {
        WorldSelectionScreenAccessor accessor = (WorldSelectionScreenAccessor)screen;
        WorldSelectionList selectionList = accessor.getList();
        if (selectionList != null) {
            for (int i = 0; i < selectionList.m_6702_().size(); ++i) {
                WorldSelectionListEntryAccessor entryAccessor;
                LevelSummary summary;
                WorldSelectionList.WorldListEntry entry = (WorldSelectionList.WorldListEntry)selectionList.m_6702_().get(i);
                if (entry == null || (summary = (entryAccessor = (WorldSelectionListEntryAccessor)entry).getWorldSummary()) == null) continue;
                boolean isFavorite = FavoritesList.contains(summary.m_78358_());
                this.drawIcon(evt, (Screen)screen, i, isFavorite, selectionList.getTop(), selectionList.m_93517_(), selectionList.getBottom());
            }
        }
    }

    @Override
    public void click(ScreenEvent.MouseClickedEvent.Pre evt, SelectWorldScreen screen) {
        WorldSelectionScreenAccessor accessor = (WorldSelectionScreenAccessor)screen;
        WorldSelectionList selectionList = accessor.getList();
        if (selectionList != null) {
            for (int i = 0; i < selectionList.m_6702_().size(); ++i) {
                WorldSelectionListEntryAccessor entryAccessor;
                LevelSummary summary;
                WorldSelectionList.WorldListEntry entry = (WorldSelectionList.WorldListEntry)selectionList.m_6702_().get(i);
                if (entry == null || (summary = (entryAccessor = (WorldSelectionListEntryAccessor)entry).getWorldSummary()) == null) continue;
                boolean isFavorite = FavoritesList.contains(summary.m_78358_());
                int top = (int)((double)(selectionList.getTop() + 15 + 36 * i) - selectionList.m_93517_());
                int x = evt.getScreen().f_96543_ / 2 - this.getOffset();
                double mouseX = evt.getMouseX();
                double mouseY = evt.getMouseY();
                if (!(mouseY >= (double)top) || !(mouseY <= (double)(top + 9)) || !(mouseX >= (double)x) || !(mouseX <= (double)(x + 9))) continue;
                String s = summary.m_78358_();
                if (isFavorite) {
                    FavoritesList.remove(s);
                } else {
                    FavoritesList.add(s);
                }
                FavoritesList.save();
                FavoriteWorlds.refreshList(selectionList);
                return;
            }
        }
    }

    @Override
    public void clicked(SelectWorldScreen screen) {
        WorldSelectionList.WorldListEntry entry;
        WorldSelectionScreenAccessor accessor = (WorldSelectionScreenAccessor)screen;
        WorldSelectionList selectionList = accessor.getList();
        if (selectionList != null && (entry = (WorldSelectionList.WorldListEntry)selectionList.m_93511_()) != null) {
            WorldSelectionListEntryAccessor entryAccessor = (WorldSelectionListEntryAccessor)entry;
            LevelSummary summary = entryAccessor.getWorldSummary();
            Button deleteButton = accessor.getDeleteButton();
            if (deleteButton != null && summary != null) {
                FavoriteWorlds.disableDeletion(summary, deleteButton);
            }
        }
    }

    @Override
    public int getOffset() {
        return 148;
    }

    private static void refreshList(WorldSelectionList listWorldSelection) {
        FavoriteWorlds.refreshList(listWorldSelection, null);
    }

    private static void refreshList(WorldSelectionList listWorldSelection, Supplier<String> supplier) {
        List list;
        Minecraft mc = Minecraft.m_91087_();
        LevelStorageSource saveformat = mc.m_91392_();
        try {
            list = saveformat.m_78244_();
        }
        catch (LevelStorageException anvilconverterexception) {
            CherishedWorldsMod.LOGGER.error("Couldn't load level list", (Throwable)anvilconverterexception);
            mc.m_91152_((Screen)new ErrorScreen((Component)new TranslatableComponent("selectWorld.unable_to_load"), (Component)new TextComponent(anvilconverterexception.getMessage())));
            return;
        }
        List entries = listWorldSelection.m_6702_();
        entries.clear();
        ListIterator iter = list.listIterator();
        ArrayList<LevelSummary> favorites = new ArrayList<LevelSummary>();
        while (iter.hasNext()) {
            LevelSummary summ = (LevelSummary)iter.next();
            if (!FavoritesList.contains(summ.m_78358_())) continue;
            favorites.add(summ);
            iter.remove();
        }
        Collections.sort(favorites);
        Collections.sort(list);
        String s = supplier == null ? "" : supplier.get().toLowerCase(Locale.ROOT);
        for (LevelSummary worldsummary : favorites) {
            if (!s.isEmpty() && !worldsummary.m_78361_().toLowerCase(Locale.ROOT).contains(s) && !worldsummary.m_78358_().toLowerCase(Locale.ROOT).contains(s)) continue;
            WorldSelectionList worldSelectionList = listWorldSelection;
            Objects.requireNonNull(worldSelectionList);
            entries.add(new WorldSelectionList.WorldListEntry(worldSelectionList, listWorldSelection, worldsummary));
        }
        for (LevelSummary worldsummary : list) {
            if (!s.isEmpty() && !worldsummary.m_78361_().toLowerCase(Locale.ROOT).contains(s) && !worldsummary.m_78358_().toLowerCase(Locale.ROOT).contains(s)) continue;
            WorldSelectionList worldSelectionList = listWorldSelection;
            Objects.requireNonNull(worldSelectionList);
            entries.add(new WorldSelectionList.WorldListEntry(worldSelectionList, listWorldSelection, worldsummary));
        }
        WorldSelectionList.WorldListEntry entry = (WorldSelectionList.WorldListEntry)listWorldSelection.m_93511_();
        if (entry != null) {
            WorldSelectionListEntryAccessor entryAccessor = (WorldSelectionListEntryAccessor)entry;
            LevelSummary summary = entryAccessor.getWorldSummary();
            Button deleteButton = ((WorldSelectionScreenAccessor)listWorldSelection.m_101685_()).getDeleteButton();
            if (deleteButton != null && summary != null) {
                FavoriteWorlds.disableDeletion(summary, deleteButton);
            }
        }
    }

    private static void disableDeletion(@Nonnull LevelSummary summary, Button deleteButton) {
        deleteButton.f_93623_ = !FavoritesList.contains(summary.m_78358_());
    }
}

