/*
 * Decompiled with CFR 0.152.
 */
package com.yurisuika.raised;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.InputConstants;
import com.yurisuika.raised.RaisedConfig;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="raised")
public class Raised {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"raised");
    public static KeyMapping down;
    public static KeyMapping up;
    public static KeyMapping offsetDown;
    public static KeyMapping offsetUp;
    public static File file;
    public static Gson gson;
    public static RaisedConfig config;

    public static void saveConfig() {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)Raised.getConfig()));
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void loadConfig() {
        try {
            config = file.exists() ? (RaisedConfig)gson.fromJson(Files.readString(file.toPath()), RaisedConfig.class) : new RaisedConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Raised.setConfig(config);
    }

    public static void setConfig(RaisedConfig config) {
        Raised.config = config;
    }

    public static RaisedConfig getConfig() {
        return config;
    }

    public static void setDistance(int change) {
        Raised.config.distance += change;
        Raised.saveConfig();
    }

    public static void setOffset(int change) {
        Raised.config.offset += change;
        Raised.saveConfig();
    }

    public static int getDistance() {
        return Raised.config.distance;
    }

    public static int getOffset() {
        return Raised.config.offset;
    }

    public void input(InputEvent.KeyInputEvent event) {
        if (down.m_90859_()) {
            Raised.setDistance(-1);
        }
        if (up.m_90859_()) {
            Raised.setDistance(1);
        }
        if (offsetDown.m_90859_()) {
            Raised.setOffset(-1);
        }
        if (offsetUp.m_90859_()) {
            Raised.setOffset(1);
        }
    }

    public Raised() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void setup(FMLClientSetupEvent event) {
        LOGGER.info("Loading Raised!");
        MinecraftForge.EVENT_BUS.addListener(this::input);
        Raised.loadConfig();
        down = new KeyMapping("raised.down", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84851_((String)"key.keyboard.minus"), "raised.title");
        up = new KeyMapping("raised.up", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84851_((String)"key.keyboard.equal"), "raised.title");
        offsetDown = new KeyMapping("raised.offset.down", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84851_((String)"key.keyboard.left.bracket"), "raised.title");
        offsetUp = new KeyMapping("raised.offset.up", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84851_((String)"key.keyboard.right.bracket"), "raised.title");
        ClientRegistry.registerKeyBinding((KeyMapping)down);
        ClientRegistry.registerKeyBinding((KeyMapping)up);
        ClientRegistry.registerKeyBinding((KeyMapping)offsetDown);
        ClientRegistry.registerKeyBinding((KeyMapping)offsetUp);
    }

    static {
        file = new File(FMLPaths.CONFIGDIR.get().toFile(), "raised.json");
        gson = new GsonBuilder().setPrettyPrinting().create();
        config = new RaisedConfig();
    }
}

